% Copyright (c) 2013, Stephen M. Anthony
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
% 
%     * Redistributions of source code must retain the above copyright
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright
%       notice, this list of conditions and the following disclaimer in
%       the documentation and/or other materials provided with the distribution
% 
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.

function sigmaEstimate = robustStandardDeviation(image)

%sigmaEstimate = robustStandardDeviation(image)
%
%robustStandardDeviation.m is designed to provide a robust estimate of the
%standard deviation of an image, relatively unperturbed by the presence of
%signals. 
%
%IMPLEMENTATION OF:
%	Sadler BM, Swami A (1999) 
%	Analysis of multiscale products for step detection and estimation.
%	IEEE Transactions on Information Theory 45: 1043-1051.
%
%DEPENDENCIES:
%	-None-
%
%INPUTS:    image:			An image, background corrected
%
%OUTPUTS:   sigmaEstimate:	The estimated standard deviation of the
%							noise of the background corrected image
%
%LIMITATIONS:
%	By making use of the median, the estimate of the standard deviation is
%	relatively robust to the presence of signals, and should provide a
%	highly accurate estimate so long as the signals are sparse. As signal
%	density increases, the estimate may no longer be accurate. 
%
%Written by Stephen M. Anthony 08/15/2013
%Last modified on 08/15/13 by Stephen M. Anthony

sigmaEstimate = median(abs(image(:) - median(image(:))))/0.67;

